


// Referenced classes of package duggelz.jape:
//            Field

class ByteField
    implements Field
{

    public ByteField(int offset)
    {
        this.offset = offset;
    }

    public String get(byte data[])
    {
        return Integer.toString(getInt(data));
    }

    public int getInt(byte data[])
    {
        int value = data[offset] & 0xff;
        return value;
    }

    public void set(byte data[], String str)
        throws NumberFormatException
    {
        int value = Integer.parseInt(str);
        setInt(data, value);
    }

    public void setInt(byte data[], int value)
    {
        data[offset] = (byte)value;
    }

    private int offset;
}